#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <tcl.h>
#include <tk.h>

#include "global.h"
#include "field.h"
#include "display.h"
#include "routine.h"
#include "evolve.h"
#include "tcl_interface.h"


int num_display1(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
Tcl_ResetResult(interp);
Tcl_SetObjResult(interp,Tcl_NewIntObj(num_display()));
return TCL_OK;
}

int display_name(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
long i;
Tcl_ResetResult(interp);
if(argc!=2){
	Tcl_AppendResult(interp,"ERROR: display_name requires one argument",NULL);
	return TCL_ERROR;
	}
i=atol(argv[1]);
if(i<0){
	Tcl_AppendResult(interp,"ERROR: display_name: argument must be positive",NULL);
	return TCL_ERROR;
	}
if(i>=num_display()){
	Tcl_AppendResult(interp,"ERROR: display_name: index too big",NULL);
	return TCL_ERROR;
	}	
Tcl_AppendResult(interp,get_display(i)->name,NULL);
return TCL_OK;
}


int find_display(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
long i;
Tcl_ResetResult(interp);
if(argc!=2){
	Tcl_AppendResult(interp,"ERROR: find_display requires one argument",NULL);
	return TCL_ERROR;
	}
for(i=0;i<num_display();i++)
	if(!strcmp(get_display(i)->name,argv[1])){
		Tcl_SetObjResult(interp,Tcl_NewIntObj(i));
		return TCL_OK;
		}	
Tcl_SetObjResult(interp,Tcl_NewIntObj(-1));
return TCL_OK;
}

int compute_type(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
long i,j,x,y;
DISPLAY *d;
FIELD *f;
u64 result;
Tcl_ResetResult(interp);
if(argc!=5){
	Tcl_AppendResult(interp,"ERROR: compute_type requires four arguments",NULL);
	return TCL_ERROR;
	}
i=atol(argv[1]);
if(i<0){
	Tcl_AppendResult(interp,"ERROR: compute_type: argument must be positive",NULL);
	return TCL_ERROR;
	}
if(i>=num_display()){
	Tcl_AppendResult(interp,"ERROR: compute_type: index too big",NULL);
	return TCL_ERROR;
	}
d=get_display(i);		
j=atol(argv[2]);
if(j<0){
	Tcl_AppendResult(interp,"ERROR: compute_type: argument must be positive",NULL);
	return TCL_ERROR;
	}
if(j>=num_fields()){
	Tcl_AppendResult(interp,"ERROR: compute_type: index too big",NULL);
	return TCL_ERROR;
	}	
f=get_field(j);	
x=atol(argv[3]);
if(x<0){
	Tcl_AppendResult(interp,"ERROR: compute_type: argument must be positive",NULL);
	return TCL_ERROR;
	}
if(x>=f->x_size){
	Tcl_AppendResult(interp,"ERROR: compute_type: index too big",NULL);
	return TCL_ERROR;
	}	
y=atol(argv[4]);
if(y<0){
	Tcl_AppendResult(interp,"ERROR: compute_type: argument must be positive",NULL);
	return TCL_ERROR;
	}
if(y>=f->y_size){
	Tcl_AppendResult(interp,"ERROR: compute_type: index too big",NULL);
	return TCL_ERROR;
	}	
set_current_field(f);
set_current_agent(x,y);	
if(evaluate_routine(d->routine_type,&result)<0)result=-1;
Tcl_SetObjResult(interp,Tcl_NewIntObj(result));
return TCL_OK;
}

int compute_color2(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
long i,j,x,y;
DISPLAY *d;
FIELD *f;
u64 result;
Tcl_ResetResult(interp);
if(argc!=5){
	Tcl_AppendResult(interp,"ERROR: compute_color2 requires four arguments",NULL);
	return TCL_ERROR;
	}
i=atol(argv[1]);
if(i<0){
	Tcl_AppendResult(interp,"ERROR: compute_color2: argument must be positive",NULL);
	return TCL_ERROR;
	}
if(i>=num_display()){
	Tcl_AppendResult(interp,"ERROR: compute_color2: index too big",NULL);
	return TCL_ERROR;
	}
d=get_display(i);		
j=atol(argv[2]);
if(j<0){
	Tcl_AppendResult(interp,"ERROR: compute_color2: argument must be positive",NULL);
	return TCL_ERROR;
	}
if(j>=num_fields()){
	Tcl_AppendResult(interp,"ERROR: compute_color2: index too big",NULL);
	return TCL_ERROR;
	}	
f=get_field(j);	
x=atol(argv[3]);
if(x<0){
	Tcl_AppendResult(interp,"ERROR: compute_color2: argument must be positive",NULL);
	return TCL_ERROR;
	}
if(x>=f->x_size){
	Tcl_AppendResult(interp,"ERROR: compute_color2: index too big",NULL);
	return TCL_ERROR;
	}	
y=atol(argv[4]);
if(y<0){
	Tcl_AppendResult(interp,"ERROR: compute_color2: argument must be positive",NULL);
	return TCL_ERROR;
	}
if(y>=f->y_size){
	Tcl_AppendResult(interp,"ERROR: compute_color2: index too big",NULL);
	return TCL_ERROR;
	}	
set_current_field(f);
set_current_agent(x,y);	
if(evaluate_routine(d->routine_index2,&result)<0)result=-1;
Tcl_SetObjResult(interp,Tcl_NewIntObj(result));
return TCL_OK;
}

int compute_color1(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
long i,j,x,y;
DISPLAY *d;
FIELD *f;
u64 result;
Tcl_ResetResult(interp);
if(argc!=5){
	Tcl_AppendResult(interp,"ERROR: compute_color1 requires four arguments",NULL);
	return TCL_ERROR;
	}
i=atol(argv[1]);
if(i<0){
	Tcl_AppendResult(interp,"ERROR: compute_color1: argument must be positive",NULL);
	return TCL_ERROR;
	}
if(i>=num_display()){
	Tcl_AppendResult(interp,"ERROR: compute_color1: index too big",NULL);
	return TCL_ERROR;
	}
d=get_display(i);		
j=atol(argv[2]);
if(j<0){
	Tcl_AppendResult(interp,"ERROR: compute_color1: argument must be positive",NULL);
	return TCL_ERROR;
	}
if(j>=num_fields()){
	Tcl_AppendResult(interp,"ERROR: compute_color1: index too big",NULL);
	return TCL_ERROR;
	}	
f=get_field(j);	
x=atol(argv[3]);
if(x<0){
	Tcl_AppendResult(interp,"ERROR: compute_color1: argument must be positive",NULL);
	return TCL_ERROR;
	}
if(x>=f->x_size){
	Tcl_AppendResult(interp,"ERROR: compute_color1: index too big",NULL);
	return TCL_ERROR;
	}	
y=atol(argv[4]);
if(y<0){
	Tcl_AppendResult(interp,"ERROR: compute_color1: argument must be positive",NULL);
	return TCL_ERROR;
	}
if(y>=f->y_size){
	Tcl_AppendResult(interp,"ERROR: compute_color1: index too big",NULL);
	return TCL_ERROR;
	}	
set_current_field(f);
set_current_agent(x,y);	
if(evaluate_routine(d->routine_index1,&result)<0)result=-1;
Tcl_SetObjResult(interp,Tcl_NewIntObj(result));
return TCL_OK;
}

int compute_color3(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
long i,j,x,y;
DISPLAY *d;
FIELD *f;
u64 result;
Tcl_ResetResult(interp);
if(argc!=5){
	Tcl_AppendResult(interp,"ERROR: compute_color3 requires four arguments",NULL);
	return TCL_ERROR;
	}
i=atol(argv[1]);
if(i<0){
	Tcl_AppendResult(interp,"ERROR: compute_color3: argument must be positive",NULL);
	return TCL_ERROR;
	}
if(i>=num_display()){
	Tcl_AppendResult(interp,"ERROR: compute_color3: index too big",NULL);
	return TCL_ERROR;
	}
d=get_display(i);		
j=atol(argv[2]);
if(j<0){
	Tcl_AppendResult(interp,"ERROR: compute_color3: argument must be positive",NULL);
	return TCL_ERROR;
	}
if(j>=num_fields()){
	Tcl_AppendResult(interp,"ERROR: compute_color3: index too big",NULL);
	return TCL_ERROR;
	}	
f=get_field(j);	
x=atol(argv[3]);
if(x<0){
	Tcl_AppendResult(interp,"ERROR: compute_color3: argument must be positive",NULL);
	return TCL_ERROR;
	}
if(x>=f->x_size){
	Tcl_AppendResult(interp,"ERROR: compute_color3: index too big",NULL);
	return TCL_ERROR;
	}	
y=atol(argv[4]);
if(y<0){
	Tcl_AppendResult(interp,"ERROR: compute_color3: argument must be positive",NULL);
	return TCL_ERROR;
	}
if(y>=f->y_size){
	Tcl_AppendResult(interp,"ERROR: compute_color3: index too big",NULL);
	return TCL_ERROR;
	}	
set_current_field(f);
set_current_agent(x,y);	
if(evaluate_routine(d->routine_index3,&result)<0)result=-1;
Tcl_SetObjResult(interp,Tcl_NewIntObj(result));
return TCL_OK;
}

